/*
 * Decompiled with CFR 0.152.
 */
package com.gus.chipmunk;

import com.gus.chipmunk.ChipMunkConstants;
import com.gus.chipmunk.ChipPart;
import com.gus.chipmunk.ChipsetImporter;
import com.gus.chipmunk.HardChipPanel;
import com.gus.chipmunk.SoftChipPanel;
import com.gus.chipmunk.TileSheet;
import com.gus.chipmunk.dialogs.AboutDialog;
import com.gus.chipmunk.dialogs.ManageLibraryDialog;
import com.gus.chipmunk.dialogs.StartDialog;
import com.gus.chipmunk.quantizer.MedianCut;
import com.gus.chipmunk.selector.ChipPartSelector;
import com.gus.chipmunk.selector.ChipSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class ChipMunk
extends JFrame
implements ChipMunkConstants {
    private static final long serialVersionUID = -4868675627153205469L;
    public static final ImageIcon MAIN_ICON = new ImageIcon(ChipMunk.class.getResource("cmicon.png"));
    private HardChipPanel hardChip;
    private SoftChipPanel softChip;
    private JCheckBox showBG;
    private ChipSelector softSel;
    private ChipPartSelector waterSel;
    private ChipPartSelector animSel;
    private ChipPartSelector autoSel;
    private JInternalFrame contChip;
    private JInternalFrame contSoft;
    private JInternalFrame contWater;
    private JInternalFrame contAnim;
    private JInternalFrame contAuto;
    private JFileChooser jfcSave;
    private ManageLibraryDialog libManager;
    private AboutDialog aboutDialog = new AboutDialog((Window)this);
    private ChipsetImporter importer;
    private TreeMap<String, ChipPart> waterParts = new TreeMap();
    private TreeMap<String, ChipPart> animParts = new TreeMap();
    private TreeMap<String, ChipPart> autoParts = new TreeMap();
    private TreeMap<String, TileSheet> tileSheets = new TreeMap();
    private static final FileFilter PNG_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isFile() && f.getName().endsWith(".png");
        }
    };
    private static final Comparator<File> FILE_NAME_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File a, File b) {
            return a.getAbsolutePath().compareTo(b.getAbsolutePath());
        }
    };

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        StartDialog sd = new StartDialog(null);
        sd.setVisible(true);
        long time = System.currentTimeMillis();
        ChipMunk cm = new ChipMunk();
        cm.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        try {
            while (System.currentTimeMillis() - time < 3000L) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        cm.setVisible(true);
        sd.dispose();
    }

    public void addPart(ChipPart cp) {
        switch (cp.tileClass) {
            case 0: {
                this.waterSel.addPart(cp);
                this.waterParts.put(cp.name, cp);
                break;
            }
            case 1: {
                this.animSel.addPart(cp);
                this.animParts.put(cp.name, cp);
                break;
            }
            case 2: {
                this.autoSel.addPart(cp);
                this.autoParts.put(cp.name, cp);
            }
        }
    }

    public void delPart(ChipPart cp) {
        String p;
        switch (cp.tileClass) {
            case 0: {
                this.waterSel.delPart(cp);
                this.waterParts.remove(cp.name);
                p = LIB_WATER;
                break;
            }
            case 1: {
                this.animSel.delPart(cp);
                this.animParts.remove(cp.name);
                p = LIB_ANIM;
                break;
            }
            case 2: {
                this.autoSel.delPart(cp);
                this.autoParts.remove(cp.name);
                p = LIB_AUTO;
                break;
            }
            default: {
                return;
            }
        }
        File f = new File(String.valueOf(p) + File.separator + cp.name);
        if (f.isFile()) {
            f.delete();
        }
    }

    public void addTileSheet(TileSheet ts) {
        this.softSel.addTileSheet(ts);
        this.tileSheets.put(ts.name, ts);
    }

    public void delTileSheet(TileSheet ts) {
        this.tileSheets.remove(ts.name);
        this.softSel.delTileSheet(ts);
        File f = new File(String.valueOf(LIB_SOFT) + File.separator + ts.name);
        if (f.isFile()) {
            f.delete();
        }
    }

    public void infoMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg, "ChipMunk", 1);
    }

    public void errorMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Error", 0);
    }

    public void warningMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Warning", 2);
    }

    public ChipMunk() {
        super("ChipMunk");
        this.setIconImage(MAIN_ICON.getImage());
        this.hardChip = new HardChipPanel();
        this.softChip = new SoftChipPanel();
        this.showBG = new JCheckBox("Show Template");
        this.softSel = new ChipSelector(){
            private static final long serialVersionUID = -7640628577685957774L;

            @Override
            protected void selectionChanged() {
                ChipMunk.this.softChip.setDrawSource(this.getSelectedImage());
                ChipMunk.this.softChip.getDrawSelection().setBounds(this.getSelection());
            }
        };
        this.waterSel = new ChipPartSelector();
        this.animSel = new ChipPartSelector();
        this.autoSel = new ChipPartSelector();
        this.importer = new ChipsetImporter(this);
        this.libManager = new ManageLibraryDialog(this);
        this.makeMenu();
        this.makeLayout();
        this.showBG.setSelected(true);
        this.showBG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChipMunk.this.hardChip.setDrawTemplate(ChipMunk.this.showBG.isSelected());
                ChipMunk.this.softChip.setDrawTemplate(ChipMunk.this.showBG.isSelected());
            }
        });
        this.loadLibrary();
    }

    private void makeMenu() {
        this.jfcSave = new JFileChooser();
        this.jfcSave.setAcceptAllFileFilterUsed(false);
        this.jfcSave.setFileFilter(new javax.swing.filechooser.FileFilter(){

            @Override
            public String getDescription() {
                return "PNG (*.png)";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.isFile() && f.getName().endsWith(".png");
            }
        });
        this.libManager.setTitle("Library Manager");
        JMenuBar bar = new JMenuBar();
        JMenu mFile = new JMenu("File");
        JMenuItem miSave = new JMenuItem("Save (True Color)");
        miSave.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
        JMenuItem miSave8b = new JMenuItem("Save (256 colors)");
        miSave8b.setAccelerator(KeyStroke.getKeyStroke("ctrl shift S"));
        JMenuItem miLibrary = new JMenuItem("Library Manager");
        miLibrary.setAccelerator(KeyStroke.getKeyStroke("ctrl L"));
        JMenuItem miIChip = new JMenuItem("Import Chipset");
        miIChip.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
        JMenuItem miExit = new JMenuItem("Exit");
        miExit.setAccelerator(KeyStroke.getKeyStroke("alt F4"));
        JMenu mHelp = new JMenu("Help");
        JMenuItem miHelpContents = new JMenuItem("Help Contents");
        miHelpContents.setAccelerator(KeyStroke.getKeyStroke("F1"));
        JMenuItem miAbout = new JMenuItem("About the ChipMunk");
        miAbout.setAccelerator(KeyStroke.getKeyStroke("alt F1"));
        miSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChipMunk.this.save(false);
            }
        });
        miSave8b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChipMunk.this.save(true);
            }
        });
        miLibrary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChipMunk.this.libManager.manage(ChipMunk.this.waterParts, ChipMunk.this.animParts, ChipMunk.this.autoParts, ChipMunk.this.tileSheets);
            }
        });
        miIChip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChipMunk.this.importer.importChip();
            }
        });
        miExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChipMunk.this.dispatchEvent(new WindowEvent(ChipMunk.this, 201));
            }
        });
        miHelpContents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().open(new File("Help.txt"));
                }
                catch (IOException e1) {
                    ChipMunk.this.errorMessage("The ChipMunk couldn't open the Help file.");
                }
            }
        });
        miAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChipMunk.this.aboutDialog.setVisible(true);
            }
        });
        this.setJMenuBar(bar);
        bar.add(mFile);
        bar.add(mHelp);
        mFile.add(miSave);
        mFile.add(miSave8b);
        mFile.addSeparator();
        mFile.add(miLibrary);
        mFile.add(miIChip);
        mFile.addSeparator();
        mFile.add(miExit);
        mHelp.add(miHelpContents);
        mHelp.add(miAbout);
    }

    private void makeLayout() {
        this.waterSel.setCols(3);
        this.animSel.setCols(8);
        this.autoSel.setCols(4);
        this.softChip.setZoomFactor(2);
        this.hardChip.setZoomFactor(2);
        final JDesktopPane desktop = new JDesktopPane();
        desktop.setOpaque(false);
        this.setContentPane(desktop);
        InternalFrameAdapter ifl = new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent arg0) {
                desktop.moveToBack(ChipMunk.this.contChip);
            }
        };
        this.contChip = new JInternalFrame("Chipset", false, false, false, false);
        this.contChip.setBorder(null);
        this.contChip.setFrameIcon(null);
        this.contChip.setLayout(new BorderLayout());
        JPanel in22 = new JPanel(new BorderLayout());
        in22.add((Component)this.showBG, "South");
        in22.add((Component)this.hardChip, "West");
        in22.add((Component)this.softChip, "Center");
        this.contChip.add((Component)in22, "North");
        desktop.add(this.contChip);
        this.contChip.pack();
        this.contChip.setLocation(5, 5);
        this.contSoft = new JInternalFrame("General", false, false, false, true);
        this.contSoft.setFrameIcon(null);
        this.contSoft.add((Component)this.softSel, "Center");
        this.contSoft.setMinimumSize(this.contSoft.getPreferredSize());
        this.contSoft.pack();
        this.contSoft.setLocation(this.contChip.getX() + this.contChip.getWidth() - this.contSoft.getWidth(), this.contChip.getY());
        desktop.add(this.contSoft);
        this.contWater = new JInternalFrame("Water", true, false, false, true);
        this.contWater.setFrameIcon(null);
        this.contWater.add((Component)this.waterSel, "Center");
        this.contWater.setPreferredSize(new Dimension(350, 300));
        this.contWater.setMinimumSize(this.contWater.getPreferredSize());
        this.contWater.pack();
        this.contWater.setLocation(this.contChip.getX(), this.contChip.getY() + this.contChip.getHeight() / 2);
        desktop.add(this.contWater);
        this.contAuto = new JInternalFrame("Autotiles", true, false, false, true);
        this.contAuto.setFrameIcon(null);
        this.contAuto.add((Component)this.autoSel, "Center");
        this.contAuto.setPreferredSize(new Dimension(260, 190));
        this.contAuto.setMinimumSize(this.contAuto.getPreferredSize());
        this.contAuto.pack();
        this.contAuto.setLocation(this.contWater.getX() + this.contWater.getWidth() + 10, this.contWater.getY() + this.contWater.getHeight() - this.contAuto.getHeight());
        desktop.add(this.contAuto);
        this.contAnim = new JInternalFrame("Animations", true, false, false, true);
        this.contAnim.setFrameIcon(null);
        this.contAnim.add((Component)this.animSel, "Center");
        this.contAnim.setPreferredSize(new Dimension(250, 190));
        this.contAnim.setMinimumSize(this.contAnim.getPreferredSize());
        this.contAnim.pack();
        this.contAnim.setLocation(this.contAuto.getX(), this.contAuto.getY() - this.contAnim.getHeight() - 5);
        desktop.add(this.contAnim);
        this.getContentPane().setPreferredSize(new Dimension(this.contChip.getX() + this.contChip.getWidth() + 5, this.contChip.getY() + this.contChip.getHeight() + 30));
        this.pack();
        this.contChip.addInternalFrameListener(ifl);
        this.contSoft.addInternalFrameListener(ifl);
        this.contWater.addInternalFrameListener(ifl);
        this.contAnim.addInternalFrameListener(ifl);
        this.contAuto.addInternalFrameListener(ifl);
        this.contChip.setVisible(true);
        this.contSoft.setVisible(true);
        this.contWater.setVisible(true);
        this.contAnim.setVisible(true);
        this.contAuto.setVisible(true);
        try {
            this.contSoft.setIcon(true);
            this.contWater.setIcon(true);
            this.contAnim.setIcon(true);
            this.contAuto.setIcon(true);
            desktop.moveToBack(this.contChip);
        }
        catch (PropertyVetoException in22) {
            // empty catch block
        }
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        center.x -= this.getWidth() / 2;
        center.y -= this.getHeight() / 2;
        this.setLocation(center);
    }

    private void checkLibrary() {
        File[] dirs;
        File baseDir = new File("lib");
        if (!baseDir.isDirectory()) {
            baseDir.mkdir();
        }
        File[] fileArray = dirs = new File[]{new File(LIB_SOFT), new File(LIB_WATER), new File(LIB_ANIM), new File(LIB_AUTO)};
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.isDirectory()) {
                f.mkdir();
            }
            ++n2;
        }
    }

    private void loadSoft(File dir, List<File> fail) {
        File[] files = dir.listFiles(PNG_FILE_FILTER);
        Arrays.sort(files, FILE_NAME_COMPARATOR);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                BufferedImage i = ImageIO.read(f);
                if (i.getWidth() != 288 || i.getHeight() != 256) {
                    throw new Exception("Wrong size");
                }
                if (i.getType() != 2) {
                    BufferedImage b = new BufferedImage(i.getWidth(), i.getHeight(), 2);
                    Graphics2D g = b.createGraphics();
                    g.drawImage((Image)i, 0, 0, null);
                    g.dispose();
                    i = b;
                }
                this.addTileSheet(new TileSheet(f.getName(), i));
            }
            catch (Exception e) {
                e.printStackTrace();
                fail.add(f);
            }
            ++n2;
        }
    }

    private void loadParts(int type, int width, int height, File dir, List<File> fail, List<Exception> failEx) {
        File[] files = dir.listFiles(PNG_FILE_FILTER);
        Arrays.sort(files, FILE_NAME_COMPARATOR);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                BufferedImage i = ImageIO.read(f);
                if (i == null) {
                    throw new Exception("Invalid or corrupt file");
                }
                if (i.getWidth() != width || i.getHeight() != height) {
                    throw new Exception("Wrong size");
                }
                if (i.getType() != 2) {
                    BufferedImage b = new BufferedImage(i.getWidth(), i.getHeight(), 2);
                    Graphics2D g = b.createGraphics();
                    g.drawImage((Image)i, 0, 0, null);
                    g.dispose();
                    i = b;
                }
                ChipPart cp = new ChipPart(i, type);
                cp.name = f.getName();
                this.addPart(cp);
            }
            catch (IOException e) {
                fail.add(f);
                failEx.add(new IOException("Error loading file", e));
            }
            catch (Exception e) {
                fail.add(f);
                failEx.add(e);
            }
            ++n2;
        }
    }

    private void loadLibrary() {
        this.checkLibrary();
        File softDir = new File(LIB_SOFT);
        File waterDir = new File(LIB_WATER);
        File animDir = new File(LIB_ANIM);
        File autoDir = new File(LIB_AUTO);
        Vector<File> fail = new Vector<File>();
        Vector<Exception> failEx = new Vector<Exception>();
        this.loadSoft(softDir, fail);
        this.loadParts(0, 96, 128, waterDir, fail, failEx);
        this.loadParts(1, 16, 64, animDir, fail, failEx);
        this.loadParts(2, 48, 64, autoDir, fail, failEx);
        if (fail.size() != 0) {
            StringBuilder s = new StringBuilder("The following files couldn't be loaded:");
            int i = 0;
            while (i < fail.size()) {
                s.append("\n").append(fail.get(i)).append(" - ").append(failEx.get(i));
                failEx.get(i).printStackTrace();
                ++i;
            }
            this.warningMessage(s.toString());
        }
    }

    private void save(boolean indexed) {
        this.jfcSave.setDialogTitle(indexed ? "Save (256 colors)" : "Save (True Color)");
        if (this.jfcSave.showSaveDialog(this) == 0) {
            BufferedImage chip = new BufferedImage(480, 256, 2);
            Graphics2D g = chip.createGraphics();
            this.hardChip.drawChip(g, 0, 0);
            this.softChip.drawChip(g, 192, 0);
            g.dispose();
            if (indexed) {
                int[] pixels = chip.getRaster().getPixels(0, 0, chip.getWidth(), chip.getHeight(), (int[])null);
                int[] newpix = new int[chip.getWidth() * chip.getHeight()];
                int i = 0;
                while (i < pixels.length) {
                    newpix[i / 4] = pixels[i + 3] << 24 | pixels[i] << 16 | pixels[i + 1] << 8 | pixels[i + 2];
                    i += 4;
                }
                MedianCut mc = new MedianCut(newpix, chip.getWidth(), chip.getHeight());
                chip = mc.convertToIndexed(255);
            }
            try {
                String path = this.jfcSave.getSelectedFile().getAbsolutePath();
                if (!path.endsWith(".png")) {
                    path = String.valueOf(path) + ".png";
                }
                ImageIO.write((RenderedImage)chip, "png", new File(path));
            }
            catch (IOException e) {
                this.errorMessage("Error saving the image.");
            }
        }
    }
}

