/*
 * Decompiled with CFR 0.152.
 */
package com.gus.chipmunk;

import com.gus.chipmunk.ChipMunkConstants;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;

public class ChipPart
implements ChipMunkConstants {
    public static final int WATER = 0;
    public static final int ANIMATION = 1;
    public static final int AUTOTILE = 2;
    public static final int SOFT = 3;
    public static final DataFlavor DF_WATER = new DataFlavor(WaterChipPart.class, WaterChipPart.class.getName());
    public static final DataFlavor DF_ANIMATION = new DataFlavor(AnimationChipPart.class, AnimationChipPart.class.getName());
    public static final DataFlavor DF_AUTOTILE = new DataFlavor(AutotileChipPart.class, AutotileChipPart.class.getName());
    public static final DataFlavor DF_SOFT = new DataFlavor(SoftChipPart.class, SoftChipPart.class.getName());
    public static final DataFlavor DF_GENERAL = new DataFlavor(ChipPart.class, ChipPart.class.getName());
    public String name;
    public BufferedImage image;
    public int tileClass;

    public ChipPart(BufferedImage image, int tileClass, String name) {
        this.image = image;
        this.tileClass = tileClass;
        this.name = name;
    }

    public ChipPart(BufferedImage image, int tileClass) {
        this(image, tileClass, null);
    }

    public DataFlavor getDataFlavor() {
        switch (this.tileClass) {
            case 0: {
                return DF_WATER;
            }
            case 1: {
                return DF_ANIMATION;
            }
            case 2: {
                return DF_AUTOTILE;
            }
            case 3: {
                return DF_SOFT;
            }
        }
        return DF_GENERAL;
    }

    public String toString() {
        return String.valueOf(this.tileClass == 0 ? "Water - " : (this.tileClass == 1 ? "Animation - " : (this.tileClass == 2 ? "Autotile - " : (this.tileClass == 3 ? "General - " : "Other - ")))) + this.name;
    }

    public static final class AnimationChipPart
    extends ChipPart {
        private AnimationChipPart() {
            super(null, 1);
        }
    }

    public static final class AutotileChipPart
    extends ChipPart {
        private AutotileChipPart() {
            super(null, 2);
        }
    }

    public static final class SoftChipPart
    extends ChipPart {
        private SoftChipPart() {
            super(null, 3);
        }
    }

    public static final class WaterChipPart
    extends ChipPart {
        private WaterChipPart() {
            super(null, 0);
        }
    }
}

