/*
 * Decompiled with CFR 0.152.
 */
package com.gus.chipmunk;

import com.gus.chipmunk.ChipMunk;
import com.gus.chipmunk.ChipMunkConstants;
import com.gus.chipmunk.ChipPart;
import com.gus.chipmunk.TileSheet;
import com.gus.chipmunk.dialogs.AskBackgroundDialog;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ChipsetImporter
implements ChipMunkConstants {
    private ChipMunk owner;
    private AskBackgroundDialog bgDialog;
    private JFileChooser jfcImportChip;

    public ChipsetImporter(ChipMunk owner) {
        this.owner = owner;
        this.bgDialog = new AskBackgroundDialog((Window)owner, "Click on the Background:");
        this.jfcImportChip = new JFileChooser();
        this.jfcImportChip.setAcceptAllFileFilterUsed(false);
        this.jfcImportChip.setDialogTitle("Import Chipset");
        this.jfcImportChip.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "PNG (*.png)";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.isFile() && f.getName().endsWith(".png");
            }
        });
    }

    private static boolean isFullyOpaque(BufferedImage im) {
        WritableRaster alpha = im.getAlphaRaster();
        int[] pix = alpha.getPixels(0, 0, im.getWidth(), im.getHeight(), (int[])null);
        int i = 0;
        while (i < pix.length) {
            if (pix[i] != 255) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isFullyTransparent(BufferedImage im) {
        WritableRaster alpha = im.getAlphaRaster();
        int[] pix = alpha.getPixels(0, 0, im.getWidth(), im.getHeight(), (int[])null);
        int i = 0;
        while (i < pix.length) {
            if (pix[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private BufferedImage cutWater(BufferedImage i) {
        BufferedImage water = new BufferedImage(96, 128, 2);
        int w = 48;
        int h = 64;
        Graphics2D g = water.createGraphics();
        g.drawImage(i, 0, 0, 2 * w, h, 0, 0, 2 * w, h, null);
        g.drawImage(i, 0, h, w, h + h, 0, h, w, h + h, null);
        g.dispose();
        return water;
    }

    private BufferedImage cutSoft(BufferedImage i) {
        BufferedImage soft = new BufferedImage(288, 256, 2);
        int x = 192;
        int w = 288;
        int h = 256;
        Graphics2D g = soft.createGraphics();
        g.drawImage(i, 0, 0, w, h, x, 0, x + w, h, null);
        g.dispose();
        return soft;
    }

    private BufferedImage[] cutAnims(BufferedImage im) {
        BufferedImage[] anims = new BufferedImage[3];
        int i = 0;
        while (i < anims.length) {
            BufferedImage anim = new BufferedImage(16, 64, 2);
            int x = 48 + i * 16;
            int y = 64;
            int w = 16;
            int h = 64;
            Graphics2D g = anim.createGraphics();
            g.drawImage(im, 0, 0, w, h, x, y, x + w, y + h, null);
            g.dispose();
            anims[i] = anim;
            ++i;
        }
        return anims;
    }

    private BufferedImage[] cutAutos(BufferedImage im) {
        BufferedImage[] autos = new BufferedImage[12];
        int i = 0;
        while (i < autos.length) {
            BufferedImage anim = new BufferedImage(48, 64, 2);
            int x = 0;
            int y = 0;
            int w = 48;
            int h = 64;
            if (i < 4) {
                x = (6 + i % 2 * 3) * 16;
                y = i / 2 * 4 * 16;
            } else {
                int sub = i - 4;
                x = sub % 4 * 3 * 16;
                y = (2 + sub / 4) * 4 * 16;
            }
            Graphics2D g = anim.createGraphics();
            g.drawImage(im, 0, 0, w, h, x, y, x + w, y + h, null);
            g.dispose();
            autos[i] = anim;
            ++i;
        }
        return autos;
    }

    private BufferedImage checkImage(BufferedImage im) throws Exception {
        if (im.getWidth() != 480 || im.getHeight() != 256) {
            throw new Exception("Wrong size");
        }
        if (im.getType() != 2) {
            BufferedImage b = new BufferedImage(im.getWidth(), im.getHeight(), 2);
            Graphics2D g = b.createGraphics();
            g.drawImage((Image)im, 0, 0, null);
            g.dispose();
            im = b;
        }
        return im;
    }

    private File savePart(BufferedImage part, String name, String path) throws IOException {
        File nf = new File(String.valueOf(path) + File.separator + name + ".png");
        int count = 0;
        while (nf.exists()) {
            nf = new File(String.valueOf(path) + File.separator + name + ++count + ".png");
        }
        ImageIO.write((RenderedImage)part, "png", nf);
        return nf;
    }

    private BufferedImage askBackground(BufferedImage im) {
        Color bg = this.bgDialog.askBG(im);
        BufferedImage aux = new BufferedImage(im.getWidth(), im.getHeight(), 2);
        int pbg = bg.getRGB();
        int a = new Color(0, 0, 0, 0).getRGB();
        int x = 0;
        while (x < im.getWidth()) {
            int y = 0;
            while (y < im.getHeight()) {
                int p = im.getRGB(x, y);
                aux.setRGB(x, y, p != pbg ? p : a);
                ++y;
            }
            ++x;
        }
        return aux;
    }

    private void saveParts(String name, Vector<File> win, BufferedImage water, BufferedImage soft, BufferedImage[] anims, BufferedImage[] autos) throws IOException {
        ChipPart cp;
        File nf;
        if (!ChipsetImporter.isFullyTransparent(water)) {
            nf = this.savePart(water, "w_" + name, LIB_WATER);
            win.add(nf);
            ChipPart cp2 = new ChipPart(water, 0);
            cp2.name = nf.getName();
            this.owner.addPart(cp2);
        }
        if (!ChipsetImporter.isFullyTransparent(soft)) {
            nf = this.savePart(soft, "s_" + name, LIB_SOFT);
            win.add(nf);
            this.owner.addTileSheet(new TileSheet(nf.getName(), soft));
        }
        int i = 0;
        while (i < anims.length) {
            if (!ChipsetImporter.isFullyTransparent(anims[i])) {
                nf = this.savePart(anims[i], "an_" + name + "_" + i, LIB_ANIM);
                win.add(nf);
                cp = new ChipPart(anims[i], 1);
                cp.name = nf.getName();
                this.owner.addPart(cp);
            }
            ++i;
        }
        i = 0;
        while (i < autos.length) {
            if (!ChipsetImporter.isFullyTransparent(autos[i])) {
                nf = this.savePart(autos[i], "au_" + name + "_" + i, LIB_AUTO);
                win.add(nf);
                cp = new ChipPart(autos[i], 2);
                cp.name = nf.getName();
                this.owner.addPart(cp);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void importChip() {
        block7: {
            block8: {
                if (this.jfcImportChip.showOpenDialog(this.owner) != 0) {
                    return;
                }
                f = this.jfcImportChip.getSelectedFile();
                water = null;
                anims = null;
                autos = null;
                soft = null;
                try {
                    im = ImageIO.read(f);
                    im = this.checkImage(im);
                    if (ChipsetImporter.isFullyOpaque(im)) {
                        im = this.askBackground(im);
                    }
                    water = this.cutWater(im);
                    anims = this.cutAnims(im);
                    autos = this.cutAutos(im);
                    soft = this.cutSoft(im);
                }
                catch (Exception e) {
                    this.owner.errorMessage("Error loading the image.\n\nDetails:\n" + e.getMessage());
                    return;
                }
                win = new Vector<File>();
                try {
                    name = f.getName().substring(0, f.getName().indexOf(46));
                    this.saveParts(name, win, water, soft, anims, autos);
                    break block7;
                }
                catch (Exception e) {
                    errmsg = "Error saving parts.";
                    if (win.size() == 0) break block8;
                    errmsg = String.valueOf(errmsg) + "\nThe following parts were successfully saved:";
                    ** for (fi : win)
                }
lbl-1000:
                // 1 sources

                {
                    errmsg = String.valueOf(errmsg) + fi;
                    continue;
                }
            }
            this.owner.errorMessage(errmsg);
            return;
        }
        this.owner.infoMessage("The Chipset \\fname\\ was successfully imported.".replace("\\fname\\", f.getName()));
        System.gc();
    }
}

