/*
 * Decompiled with CFR 0.152.
 */
package com.gus.chipmunk;

import com.gus.chipmunk.ChipMunkConstants;
import com.gus.chipmunk.ChipPart;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class HardChipPanel
extends JPanel
implements ChipMunkConstants {
    private static final long serialVersionUID = 6798440934500139702L;
    private static final BufferedImage BG;
    private static final Color DROP_AREA_SHADOW;
    private static final Color SELECTED_AREA_SHADOW;
    public static final int NONE = -1;
    public static final int WATER = 0;
    public static final int ANIM_1 = 1;
    public static final int ANIM_2 = 2;
    public static final int ANIM_3 = 3;
    public static final int MIN_AUTOTILE = 4;
    public static final int MAX_AUTOTILE = 15;
    private boolean drawTemplate = true;
    private int zoomFactor = 1;
    private DropTarget dropTarget;
    private int dropArea = -1;
    private BufferedImage water;
    private BufferedImage[] anims = new BufferedImage[3];
    private BufferedImage[] autotiles = new BufferedImage[12];
    private int selectedArea = -1;

    static {
        BufferedImage bg = null;
        try {
            bg = ImageIO.read(HardChipPanel.class.getResourceAsStream("hardTemplate.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        BG = bg;
        DROP_AREA_SHADOW = new Color(255, 255, 255, 130);
        SELECTED_AREA_SHADOW = new Color(0, 255, 255, 130);
    }

    public boolean isDrawTemplate() {
        return this.drawTemplate;
    }

    public void setDrawTemplate(boolean drawTemplate) {
        this.drawTemplate = drawTemplate;
        this.repaint();
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(int zoomFactor) {
        if (zoomFactor <= 0) {
            throw new IllegalArgumentException("zoomFactor must be > 0");
        }
        this.zoomFactor = zoomFactor;
        this.setPreferredSize(new Dimension(BG.getWidth() * zoomFactor, BG.getHeight() * zoomFactor));
        this.repaint();
    }

    public HardChipPanel() {
        this.setPreferredSize(new Dimension(BG.getWidth() * this.zoomFactor, BG.getHeight() * this.zoomFactor));
        this.createDND();
        this.createSelector();
    }

    private void createDND() {
        this.dropTarget = new DropTarget(this, 3, new DropTargetAdapter(){

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                int area = HardChipPanel.this.whatArea(dtde.getLocation());
                if (dtde.isDataFlavorSupported(HardChipPanel.this.areaDataFlavor(area))) {
                    HardChipPanel.this.selectDropArea(area);
                } else {
                    HardChipPanel.this.selectDropArea(-1);
                }
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                HardChipPanel.this.selectDropArea(-1);
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                int area = HardChipPanel.this.whatArea(dtde.getLocation());
                DataFlavor df = HardChipPanel.this.areaDataFlavor(area);
                if (dtde.isDataFlavorSupported(df)) {
                    dtde.acceptDrop(3);
                    ChipPart cp = null;
                    try {
                        cp = (ChipPart)dtde.getTransferable().getTransferData(df);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (cp != null) {
                        dtde.dropComplete(true);
                        switch (area) {
                            case 0: {
                                HardChipPanel.this.water = cp.image;
                                break;
                            }
                            case 1: {
                                ((HardChipPanel)HardChipPanel.this).anims[0] = cp.image;
                                break;
                            }
                            case 2: {
                                ((HardChipPanel)HardChipPanel.this).anims[1] = cp.image;
                                break;
                            }
                            case 3: {
                                ((HardChipPanel)HardChipPanel.this).anims[2] = cp.image;
                                break;
                            }
                            default: {
                                ((HardChipPanel)HardChipPanel.this).autotiles[area - 4] = cp.image;
                                break;
                            }
                        }
                    } else {
                        dtde.dropComplete(false);
                    }
                }
                HardChipPanel.this.selectDropArea(-1);
            }
        }, true);
    }

    private synchronized int whatArea(Point p) {
        int btw = 16 * this.zoomFactor;
        int tx = p.x / btw;
        int ty = p.y / btw;
        if (tx >= 12 || ty >= 16 || tx < 0 || ty < 0) {
            return -1;
        }
        if (tx < 6 && ty < 8) {
            if (tx < 3 || ty < 4) {
                return 0;
            }
            switch (tx) {
                case 3: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 5: {
                    return 3;
                }
            }
        }
        if (ty < 8) {
            return 4 + ty / 4 * 2 + (tx - 6) / 3;
        }
        return 8 + (ty - 8) / 4 * 4 + tx / 3;
    }

    private synchronized DataFlavor areaDataFlavor(int area) {
        switch (area) {
            case 0: {
                return ChipPart.DF_WATER;
            }
            case 1: 
            case 2: 
            case 3: {
                return ChipPart.DF_ANIMATION;
            }
        }
        if (area >= 4 && area <= 15) {
            return ChipPart.DF_AUTOTILE;
        }
        return null;
    }

    private synchronized void selectDropArea(int area) {
        this.dropArea = area;
        this.repaint();
    }

    public synchronized boolean isDropEnabled() {
        return this.dropTarget.isActive();
    }

    public synchronized void setDropEnabled(boolean b) {
        this.dropTarget.setActive(b);
    }

    private void createSelector() {
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int a = HardChipPanel.this.whatArea(e.getPoint());
                if (a == HardChipPanel.this.selectedArea) {
                    a = -1;
                }
                HardChipPanel.this.selectArea(a);
                HardChipPanel.this.requestFocus();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    HardChipPanel.this.clearSelectedArea();
                }
            }
        });
    }

    public synchronized void selectArea(int area) {
        switch (area) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                if (area >= 4 && area <= 15) break;
                area = -1;
            }
        }
        this.selectedArea = area;
        this.repaint();
    }

    public synchronized void clearSelectedArea() {
        switch (this.selectedArea) {
            case -1: {
                break;
            }
            case 0: {
                this.water = null;
                break;
            }
            case 1: {
                this.anims[0] = null;
                break;
            }
            case 2: {
                this.anims[1] = null;
                break;
            }
            case 3: {
                this.anims[2] = null;
                break;
            }
            default: {
                this.autotiles[this.selectedArea - 4] = null;
            }
        }
        this.selectedArea = -1;
        this.repaint();
    }

    protected synchronized void paintBackground(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.isDrawTemplate()) {
            g.drawImage(BG, 0, 0, BG.getWidth() * this.zoomFactor, BG.getHeight() * this.zoomFactor, null);
        }
        this.drawBigChip(g, 0, 0);
    }

    private void paintArea(Graphics g, int area) {
        int btw = 16 * this.zoomFactor;
        switch (area) {
            case -1: {
                break;
            }
            case 0: {
                g.fillRect(0, 0, 6 * btw, 4 * btw);
                g.fillRect(0, 4 * btw, 3 * btw, 4 * btw);
                break;
            }
            case 1: {
                g.fillRect(3 * btw, 4 * btw, btw, 4 * btw);
                break;
            }
            case 2: {
                g.fillRect(4 * btw, 4 * btw, btw, 4 * btw);
                break;
            }
            case 3: {
                g.fillRect(5 * btw, 4 * btw, btw, 4 * btw);
                break;
            }
            default: {
                int atid = area - 4;
                if (atid < 4) {
                    g.fillRect((6 + atid % 2 * 3) * btw, atid / 2 * 4 * btw, 3 * btw, 4 * btw);
                    break;
                }
                g.fillRect((atid -= 4) % 4 * 3 * btw, (2 + atid / 4) * 4 * btw, 3 * btw, 4 * btw);
            }
        }
    }

    protected synchronized void paintOver(Graphics g) {
        g.setColor(DROP_AREA_SHADOW);
        this.paintArea(g, this.dropArea);
        if (this.isFocusOwner()) {
            g.setColor(SELECTED_AREA_SHADOW);
            this.paintArea(g, this.selectedArea);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paintBackground(g);
        this.paintOver(g);
    }

    public void drawBigChip(Graphics g, int x, int y) {
        int btw = 16 * this.zoomFactor;
        if (this.water != null) {
            g.drawImage(this.water, 0, 0, this.water.getWidth() * this.zoomFactor, this.water.getHeight() * this.zoomFactor, null);
        }
        int i = 0;
        while (i < this.anims.length) {
            if (this.anims[i] != null) {
                g.drawImage(this.anims[i], (3 + i) * btw, 4 * btw, this.anims[i].getWidth() * this.zoomFactor, this.anims[i].getHeight() * this.zoomFactor, null);
            }
            ++i;
        }
        i = 0;
        while (i < this.autotiles.length) {
            if (this.autotiles[i] != null) {
                if (i < 4) {
                    g.drawImage(this.autotiles[i], (6 + i % 2 * 3) * btw, i / 2 * 4 * btw, this.autotiles[i].getWidth() * this.zoomFactor, this.autotiles[i].getHeight() * this.zoomFactor, null);
                } else {
                    int sub = i - 4;
                    g.drawImage(this.autotiles[i], sub % 4 * 3 * btw, (2 + sub / 4) * 4 * btw, this.autotiles[i].getWidth() * this.zoomFactor, this.autotiles[i].getHeight() * this.zoomFactor, null);
                }
            }
            ++i;
        }
    }

    public void drawChip(Graphics g, int x, int y) {
        if (this.water != null) {
            g.drawImage(this.water, 0, 0, null);
        }
        int i = 0;
        while (i < this.anims.length) {
            if (this.anims[i] != null) {
                g.drawImage(this.anims[i], (3 + i) * 16, 64, null);
            }
            ++i;
        }
        i = 0;
        while (i < this.autotiles.length) {
            if (i < 4) {
                g.drawImage(this.autotiles[i], (6 + i % 2 * 3) * 16, i / 2 * 4 * 16, null);
            } else {
                int sub = i - 4;
                g.drawImage(this.autotiles[i], sub % 4 * 3 * 16, (2 + sub / 4) * 4 * 16, null);
            }
            ++i;
        }
    }
}

