/*
 * Decompiled with CFR 0.152.
 */
package com.gus.chipmunk;

import com.gus.chipmunk.ChipMunkConstants;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class SoftChipPanel
extends JPanel
implements ChipMunkConstants {
    private static final long serialVersionUID = 5817276201851389591L;
    private static final BufferedImage BG;
    private int zoomFactor = 1;
    private boolean drawTemplate = true;
    private BufferedImage chip;
    private BufferedImage drawSource = null;
    private Rectangle drawSelection = new Rectangle(-1, -1, 0, 0);

    static {
        BufferedImage bg = null;
        try {
            bg = ImageIO.read(SoftChipPanel.class.getResourceAsStream("softTemplate.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        BG = bg;
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(int zoomFactor) {
        if (zoomFactor <= 0) {
            throw new IllegalArgumentException("zoomFactor must be > 0");
        }
        this.zoomFactor = zoomFactor;
        this.setPreferredSize(new Dimension(BG.getWidth() * zoomFactor, BG.getHeight() * zoomFactor));
        this.repaint();
    }

    public boolean isDrawTemplate() {
        return this.drawTemplate;
    }

    public void setDrawTemplate(boolean drawTemplate) {
        this.drawTemplate = drawTemplate;
        this.repaint();
    }

    public SoftChipPanel() {
        this.setPreferredSize(new Dimension(BG.getWidth() * this.zoomFactor, BG.getHeight() * this.zoomFactor));
        this.chip = new BufferedImage(BG.getWidth(), BG.getHeight(), 2);
        MouseAdapter ma = new MouseAdapter(){
            private Point lastTile = null;

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getX() < 0 || e.getX() >= SoftChipPanel.this.getWidth() || e.getY() < 0 || e.getY() >= SoftChipPanel.this.getHeight()) {
                    return;
                }
                int btw = 16 * SoftChipPanel.this.zoomFactor;
                int tx = e.getX() / btw;
                int ty = e.getY() / btw * 16;
                this.lastTile = new Point(tx, ty);
                SoftChipPanel.this.drawIt(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int ty;
                if (e.getX() < 0 || e.getX() >= SoftChipPanel.this.getWidth() || e.getY() < 0 || e.getY() >= SoftChipPanel.this.getHeight()) {
                    return;
                }
                int btw = 16 * SoftChipPanel.this.zoomFactor;
                int tx = e.getX() / btw;
                if (!this.lastTile.equals(new Point(tx, ty = e.getY() / btw * 16))) {
                    this.lastTile = new Point(tx, ty);
                    SoftChipPanel.this.drawIt(e);
                }
            }
        };
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
    }

    private synchronized void drawIt(MouseEvent e) {
        if (this.drawSource == null || this.drawSelection.width == 0 || this.drawSelection.height == 0) {
            return;
        }
        int btw = 16 * this.zoomFactor;
        int dx = e.getX() / btw * 16;
        int dy = e.getY() / btw * 16;
        int sx = this.drawSelection.x * 16;
        int sy = this.drawSelection.y * 16;
        int w = this.drawSelection.width * 16;
        int h = this.drawSelection.height * 16;
        int auxw = dx + w > this.chip.getWidth() ? this.chip.getWidth() - dx : w;
        int auxh = dy + h > this.chip.getHeight() ? this.chip.getHeight() - dy : h;
        int[] alpha = new int[auxw * auxh];
        WritableRaster wr = this.chip.getAlphaRaster();
        wr.setPixels(dx, dy, auxw, auxh, alpha);
        Graphics2D g = this.chip.createGraphics();
        g.drawImage(this.drawSource, dx, dy, dx + w, dy + h, sx, sy, sx + w, sy + h, null);
        g.dispose();
        this.repaint();
    }

    public BufferedImage getDrawSource() {
        return this.drawSource;
    }

    public void setDrawSource(BufferedImage drawSource) {
        this.drawSource = drawSource;
    }

    public Rectangle getDrawSelection() {
        return this.drawSelection;
    }

    public void drawChip(Graphics g, int x, int y) {
        g.drawImage(this.chip, x, y, null);
    }

    @Override
    protected synchronized void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.isDrawTemplate()) {
            g.drawImage(BG, 0, 0, BG.getWidth() * this.zoomFactor, BG.getHeight() * this.zoomFactor, null);
        }
        g.drawImage(this.chip, 0, 0, this.chip.getWidth() * this.zoomFactor, this.chip.getHeight() * this.zoomFactor, null);
    }
}

