/*
 * Decompiled with CFR 0.152.
 */
package com.gus.chipmunk.dialogs;

import com.gus.comps.image.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class AskBackgroundDialog
extends JDialog {
    private static final long serialVersionUID = -8528805495200302489L;
    private BlinkingImagePanel bip;

    public AskBackgroundDialog(Window owner, String title) {
        super(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(0);
        this.bip = new BlinkingImagePanel(null, Color.BLACK);
        JButton bOk = new JButton("Ok");
        this.setLayout(new BorderLayout());
        this.add((Component)this.bip, "Center");
        this.add((Component)bOk, "South");
        bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AskBackgroundDialog.this.setVisible(false);
            }
        });
        this.bip.ip.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getX() >= AskBackgroundDialog.this.bip.getImage().getWidth() || e.getY() >= AskBackgroundDialog.this.bip.getImage().getHeight() || e.getX() < 0 || e.getY() < 0) {
                    return;
                }
                Color c = new Color(AskBackgroundDialog.this.bip.getImage().getRGB(e.getX(), e.getY()));
                AskBackgroundDialog.this.bip.setImage(AskBackgroundDialog.this.bip.getImage(), c);
            }
        });
    }

    public Color askBG(BufferedImage im) {
        if (this.isVisible()) {
            throw new IllegalThreadStateException("Can't call that in a visible dialog.");
        }
        this.bip.setImage(im, Color.BLACK);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.pack();
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        center.x -= this.getWidth() / 2;
        center.y -= this.getHeight() / 2;
        this.setLocation(center);
        this.setVisible(true);
        return this.bip.getBg();
    }

    private static class BlinkingImagePanel
    extends JPanel {
        private static final long serialVersionUID = -6707001203212800630L;
        private Object lock = new Object();
        private ImagePanel ip = new ImagePanel();
        private BufferedImage main;
        private BufferedImage aux;
        private Color bg;

        private void startThread() {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean b = true;
                    while (BlinkingImagePanel.this.isShowing()) {
                        Object object = BlinkingImagePanel.this.lock;
                        synchronized (object) {
                            BlinkingImagePanel.this.ip.setImage(b ? BlinkingImagePanel.this.main : BlinkingImagePanel.this.aux);
                        }
                        b = !b;
                        try {
                            Thread.sleep(400L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }.start();
        }

        public BlinkingImagePanel(BufferedImage image, Color bg) {
            super(new BorderLayout());
            this.add(this.ip);
            this.setImage(image, bg);
            this.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    BlinkingImagePanel.this.startThread();
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    BlinkingImagePanel.this.startThread();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setImage(BufferedImage im, Color bg) {
            Object object = this.lock;
            synchronized (object) {
                if (im != null) {
                    this.main = im;
                    Color nbg = new Color(0, 0, 0, 0);
                    this.aux = new BufferedImage(im.getWidth(), im.getHeight(), im.getType());
                    int pbg = bg.getRGB();
                    int pnbg = nbg.getRGB();
                    int x = 0;
                    while (x < this.main.getWidth()) {
                        int y = 0;
                        while (y < this.main.getHeight()) {
                            int p = im.getRGB(x, y);
                            this.aux.setRGB(x, y, p != pbg ? p : pnbg);
                            ++y;
                        }
                        ++x;
                    }
                } else {
                    this.aux = null;
                    this.main = null;
                }
                this.ip.setImage(this.main);
                this.bg = bg;
            }
        }

        public Color getBg() {
            return this.bg;
        }

        public BufferedImage getImage() {
            return this.main;
        }
    }
}

