/*
 * Decompiled with CFR 0.152.
 */
package com.gus.chipmunk.dialogs;

import com.gus.chipmunk.ChipMunk;
import com.gus.chipmunk.ChipPart;
import com.gus.chipmunk.TileSheet;
import com.gus.comps.image.ImagePanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManageLibraryDialog
extends JDialog {
    private static final long serialVersionUID = -565532668053349408L;
    private ChipMunk cm;
    private ImagePanel ip;
    private DefaultListModel list = new DefaultListModel();
    private JList jl;

    public ManageLibraryDialog(ChipMunk app) {
        super(app);
        if (app == null) {
            throw new NullPointerException();
        }
        this.cm = app;
        this.jl = new JList(this.list);
        this.ip = new ImagePanel();
        this.jl.setSelectionMode(1);
        this.jl.setBorder(new BevelBorder(1));
        JScrollPane jsp = new JScrollPane(this.jl);
        jsp.setPreferredSize(new Dimension(200, 300));
        this.add((Component)jsp, "West");
        final JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 10;
        p.add((Component)this.ip, c);
        p.setPreferredSize(new Dimension(300, 300));
        this.add((Component)p, "Center");
        this.jl.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object[] a = ManageLibraryDialog.this.jl.getSelectedValues();
                if (a == null || a.length == 0) {
                    return;
                }
                Object o = a[a.length - 1];
                if (o == null) {
                    return;
                }
                if (o instanceof TileSheet) {
                    ManageLibraryDialog.this.ip.setImage(((TileSheet)o).image);
                } else if (o instanceof ChipPart) {
                    ManageLibraryDialog.this.ip.setImage(((ChipPart)o).image);
                } else {
                    ManageLibraryDialog.this.ip.setImage(null);
                }
                p.doLayout();
            }
        });
        this.jl.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 127) {
                    return;
                }
                Object[] a = ManageLibraryDialog.this.jl.getSelectedValues();
                if (a == null || a.length == 0) {
                    return;
                }
                String s = "Tem certeza que deseja apagar os itens abaixo?";
                Object[] objectArray = a;
                int n = a.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    s = String.valueOf(s) + "\n" + o;
                    ++n2;
                }
                int r = JOptionPane.showConfirmDialog(ManageLibraryDialog.this, s, "Apagar", 0);
                if (r != 0) {
                    return;
                }
                Object[] objectArray2 = a;
                int n3 = a.length;
                n = 0;
                while (n < n3) {
                    Object o = objectArray2[n];
                    ManageLibraryDialog.this.list.removeElement(o);
                    if (o instanceof ChipPart) {
                        ManageLibraryDialog.this.cm.delPart((ChipPart)o);
                    } else if (o instanceof TileSheet) {
                        ManageLibraryDialog.this.cm.delTileSheet((TileSheet)o);
                    }
                    ++n;
                }
                ManageLibraryDialog.this.ip.setImage(null);
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.pack();
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        center.x -= this.getWidth() / 2;
        center.y -= this.getHeight() / 2;
        this.setLocation(center);
    }

    private void addToList(Collection<?> c) {
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            this.list.addElement(it.next());
        }
    }

    public void manage(Map<String, ChipPart> waterParts, Map<String, ChipPart> animParts, Map<String, ChipPart> autoParts, Map<String, TileSheet> tileSheets) {
        this.list.clear();
        this.addToList(waterParts.values());
        this.addToList(animParts.values());
        this.addToList(autoParts.values());
        this.addToList(tileSheets.values());
        if (!this.list.isEmpty()) {
            this.jl.setSelectedIndex(0);
        }
        this.setVisible(true);
    }
}

