/*
 * Decompiled with CFR 0.152.
 */
package com.gus.chipmunk.quantizer;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

public class MedianCut {
    public static final int MAXCOLORS = 255;
    private static final int HSIZE = 32768;
    private int[] hist;
    private int[] histPtr;
    private Cube[] list;
    private int[] pixels32;
    private int width;
    private int height;
    private IndexColorModel cm;

    public MedianCut(int[] pixels, int width, int height) {
        this.pixels32 = pixels;
        this.width = width;
        this.height = height;
        this.hist = new int[32768];
        int i = 0;
        while (i < width * height) {
            if (MedianCut.opaque(this.pixels32[i])) {
                int color16;
                int n = color16 = MedianCut.rgb(this.pixels32[i]);
                this.hist[n] = this.hist[n] + 1;
            }
            ++i;
        }
    }

    public int getColorCount() {
        int count = 0;
        int i = 0;
        while (i < 32768) {
            if (this.hist[i] > 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static final int rgb(int c) {
        int r = (c & 0xF80000) >> 19;
        int g = (c & 0xF800) >> 6;
        int b = (c & 0xF8) << 7;
        return b | g | r;
    }

    public static boolean opaque(int c) {
        return (c & 0xFF000000) != 0;
    }

    private final int red(int x) {
        return (x & 0x1F) << 3;
    }

    private final int green(int x) {
        return x >> 2 & 0xF8;
    }

    private final int blue(int x) {
        return x >> 7 & 0xF8;
    }

    public BufferedImage convertToIndexed(int maxcubes) {
        if (maxcubes > 255) {
            throw new IllegalArgumentException("maxcubes must be <= MAXCUBES");
        }
        int longdim = 0;
        this.list = new Cube[255];
        this.histPtr = new int[32768];
        int ncubes = 0;
        Cube cube = new Cube();
        int i = 0;
        int color = 0;
        while (i <= Short.MAX_VALUE) {
            if (this.hist[i] != 0) {
                this.histPtr[color++] = i;
                cube.count += this.hist[i];
            }
            ++i;
        }
        cube.lower = 0;
        cube.upper = color - 1;
        cube.level = 0;
        this.Shrink(cube);
        this.list[ncubes++] = cube;
        while (ncubes < maxcubes) {
            int level = 255;
            int splitpos = -1;
            int k = 0;
            while (k <= ncubes - 1) {
                if (this.list[k].lower != this.list[k].upper && this.list[k].level < level) {
                    level = this.list[k].level;
                    splitpos = k;
                }
                ++k;
            }
            if (splitpos == -1) break;
            cube = this.list[splitpos];
            int lr = cube.rmax - cube.rmin;
            int lg = cube.gmax - cube.gmin;
            int lb = cube.bmax - cube.bmin;
            if (lr >= lg && lr >= lb) {
                longdim = 0;
            }
            if (lg >= lr && lg >= lb) {
                longdim = 1;
            }
            if (lb >= lr && lb >= lg) {
                longdim = 2;
            }
            this.reorderColors(this.histPtr, cube.lower, cube.upper, longdim);
            this.quickSort(this.histPtr, cube.lower, cube.upper);
            this.restoreColorOrder(this.histPtr, cube.lower, cube.upper, longdim);
            int count = 0;
            i = cube.lower;
            while (i <= cube.upper - 1) {
                if (count >= cube.count / 2) break;
                color = this.histPtr[i];
                count += this.hist[color];
                ++i;
            }
            int median = i;
            Cube cubeA = new Cube();
            cubeA.lower = cube.lower;
            cubeA.upper = median - 1;
            cubeA.count = count;
            cubeA.level = cube.level + 1;
            this.Shrink(cubeA);
            this.list[splitpos] = cubeA;
            Cube cubeB = new Cube();
            cubeB.lower = median;
            cubeB.upper = cube.upper;
            cubeB.count = cube.count - count;
            cubeB.level = cube.level + 1;
            this.Shrink(cubeB);
            this.list[ncubes++] = cubeB;
        }
        this.makeInverseMap(this.hist, ncubes);
        return this.makeImage(ncubes);
    }

    private void Shrink(Cube cube) {
        int rmin = 255;
        int rmax = 0;
        int gmin = 255;
        int gmax = 0;
        int bmin = 255;
        int bmax = 0;
        int i = cube.lower;
        while (i <= cube.upper) {
            int color = this.histPtr[i];
            int r = this.red(color);
            int g = this.green(color);
            int b = this.blue(color);
            if (r > rmax) {
                rmax = r;
            }
            if (r < rmin) {
                rmin = r;
            }
            if (g > gmax) {
                gmax = g;
            }
            if (g < gmin) {
                gmin = g;
            }
            if (b > bmax) {
                bmax = b;
            }
            if (b < bmin) {
                bmin = b;
            }
            ++i;
        }
        cube.rmin = rmin;
        cube.rmax = rmax;
        cube.gmin = gmin;
        cube.gmax = gmax;
        cube.gmin = gmin;
        cube.gmax = gmax;
    }

    private void makeInverseMap(int[] hist, int ncubes) {
        int color;
        int i;
        Cube cube;
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        int k = 0;
        while (k <= ncubes - 1) {
            int b;
            int g;
            int r;
            cube = this.list[k];
            float bsum = 0.0f;
            float gsum = 0.0f;
            float rsum = 0.0f;
            i = cube.lower;
            while (i <= cube.upper) {
                color = this.histPtr[i];
                r = this.red(color);
                rsum += (float)r * (float)hist[color];
                g = this.green(color);
                gsum += (float)g * (float)hist[color];
                b = this.blue(color);
                bsum += (float)b * (float)hist[color];
                ++i;
            }
            r = (int)(rsum / (float)cube.count);
            g = (int)(gsum / (float)cube.count);
            b = (int)(bsum / (float)cube.count);
            if (r == 248 && g == 248 && b == 248) {
                b = 255;
                g = 255;
                r = 255;
            }
            rLUT[k] = (byte)r;
            gLUT[k] = (byte)g;
            bLUT[k] = (byte)b;
            ++k;
        }
        byte[] alpha = new byte[ncubes + 1];
        i = 0;
        while (i < ncubes) {
            alpha[i] = -1;
            ++i;
        }
        alpha[ncubes] = 0;
        this.cm = new IndexColorModel(8, ncubes + 1, rLUT, gLUT, bLUT, alpha);
        int k2 = 0;
        while (k2 <= ncubes - 1) {
            cube = this.list[k2];
            int i2 = cube.lower;
            while (i2 <= cube.upper) {
                color = this.histPtr[i2];
                hist[color] = k2;
                ++i2;
            }
            ++k2;
        }
    }

    private void reorderColors(int[] a, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                int i = lo;
                while (i <= hi) {
                    int c = a[i];
                    int r = c & 0x1F;
                    a[i] = r << 10 | c >> 5;
                    ++i;
                }
                break;
            }
            case 1: {
                int i = lo;
                while (i <= hi) {
                    int c = a[i];
                    int r = c & 0x1F;
                    int g = c >> 5 & 0x1F;
                    int b = c >> 10;
                    a[i] = g << 10 | b << 5 | r;
                    ++i;
                }
                break;
            }
        }
    }

    private void restoreColorOrder(int[] a, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                int i = lo;
                while (i <= hi) {
                    int c = a[i];
                    int r = c >> 10;
                    a[i] = (c & 0x3FF) << 5 | r;
                    ++i;
                }
                break;
            }
            case 1: {
                int i = lo;
                while (i <= hi) {
                    int c = a[i];
                    int r = c & 0x1F;
                    int g = c >> 10;
                    int b = c >> 5 & 0x1F;
                    a[i] = b << 10 | g << 5 | r;
                    ++i;
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void quickSort(int[] a, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = a[(lo0 + hi0) / 2];
            ** GOTO lbl18
            {
                ++lo;
                do {
                    if (lo < hi0 && a[lo] < mid) continue block0;
                    while (hi > lo0 && a[hi] > mid) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                    ++lo;
                    --hi;
lbl18:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    private BufferedImage makeImage(int ncubes) {
        int[] pixels8 = new int[this.width * this.height];
        int i = 0;
        while (i < this.width * this.height) {
            if (!MedianCut.opaque(this.pixels32[i])) {
                pixels8[i] = (byte)this.cm.getTransparentPixel();
            } else {
                int color16 = MedianCut.rgb(this.pixels32[i]);
                pixels8[i] = (byte)this.hist[color16];
            }
            ++i;
        }
        BufferedImage bi = new BufferedImage(this.width, this.height, 13, this.cm);
        bi.getRaster().setPixels(0, 0, this.width, this.height, pixels8);
        return bi;
    }

    private static class Cube {
        int lower;
        int upper;
        int count = 0;
        int level;
        int rmin;
        int rmax;
        int gmin;
        int gmax;
        int bmin;
        int bmax;

        Cube() {
        }

        public String toString() {
            String s = "lower=" + this.lower + " upper=" + this.upper;
            s = String.valueOf(s) + " count=" + this.count + " level=" + this.level;
            s = String.valueOf(s) + " rmin=" + this.rmin + " rmax=" + this.rmax;
            s = String.valueOf(s) + " gmin=" + this.gmin + " gmax=" + this.gmax;
            s = String.valueOf(s) + " bmin=" + this.bmin + " bmax=" + this.bmax;
            return s;
        }
    }
}

