/*
 * Decompiled with CFR 0.152.
 */
package com.gus.chipmunk.selector;

import com.gus.chipmunk.ChipPart;
import com.gus.comps.image.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import javax.swing.JPanel;

public class ChipPartPanel
extends JPanel {
    private static final long serialVersionUID = 5244486229098057693L;
    public static final int ALL_CLASSES = -1;
    private ChipPart part;
    private ImagePanel img;
    private DragGestureRecognizer dgr;
    private DropTarget dropTarget;
    private int acceptableTileClass = -1;
    private DataFlavor dataFlavor = ChipPart.DF_GENERAL;

    public ChipPartPanel() {
        super(new BorderLayout());
        this.img = new ImagePanel(null);
        this.add((Component)this.img, "Center");
        this.createDND();
    }

    public ChipPartPanel(ChipPart cp) {
        this();
        this.setPart(cp);
    }

    private void createDND() {
        this.dgr = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 3, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                dge.startDrag(null, new Transferable(){

                    @Override
                    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
                        if (!this.isDataFlavorSupported(df)) {
                            throw new UnsupportedFlavorException(df);
                        }
                        return ChipPartPanel.this.getPart();
                    }

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        if (ChipPartPanel.this.getPart() == null) {
                            return null;
                        }
                        DataFlavor[] dfs = new DataFlavor[]{ChipPartPanel.this.getPart().getDataFlavor(), ChipPart.DF_GENERAL};
                        return dfs;
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        if (ChipPartPanel.this.getPart() == null) {
                            return false;
                        }
                        return flavor.match(ChipPartPanel.this.getPart().getDataFlavor()) || flavor.match(ChipPart.DF_GENERAL);
                    }
                });
            }
        });
        this.dropTarget = new DropTarget(this, 3, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                System.out.println(dtde.getDropAction());
                DataFlavor df = ChipPartPanel.this.dataFlavor;
                if (dtde.isDataFlavorSupported(df)) {
                    dtde.acceptDrop(3);
                    ChipPart cp = null;
                    try {
                        cp = (ChipPart)dtde.getTransferable().getTransferData(df);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (cp != null && (ChipPartPanel.this.getAcceptableTileClass() == -1 || cp.tileClass == ChipPartPanel.this.getAcceptableTileClass())) {
                        ChipPartPanel.this.setPart(cp);
                        dtde.dropComplete(true);
                    } else {
                        dtde.dropComplete(false);
                    }
                }
            }
        }, true);
    }

    public boolean isDragEnabled() {
        return this.dgr.getComponent() == this;
    }

    public void setDragEnabled(boolean b) {
        this.dgr.setComponent(b ? this : null);
    }

    public int getAcceptableTileClass() {
        return this.acceptableTileClass;
    }

    public void setAcceptableTileClass(int acceptableTileClass) {
        this.acceptableTileClass = acceptableTileClass;
        switch (acceptableTileClass) {
            case 0: {
                this.dataFlavor = ChipPart.DF_WATER;
                break;
            }
            case 1: {
                this.dataFlavor = ChipPart.DF_ANIMATION;
                break;
            }
            case 2: {
                this.dataFlavor = ChipPart.DF_AUTOTILE;
                break;
            }
            case 3: {
                this.dataFlavor = ChipPart.DF_SOFT;
                break;
            }
            default: {
                this.acceptableTileClass = -1;
                this.dataFlavor = ChipPart.DF_GENERAL;
            }
        }
    }

    public boolean isDropEnabled() {
        return this.dropTarget.isActive();
    }

    public void setDropEnabled(boolean b) {
        this.dropTarget.setActive(b);
    }

    public ChipPart getPart() {
        return this.part;
    }

    public void setPart(ChipPart part) {
        this.part = part;
        this.img.setImage(part != null ? part.image : null);
    }
}

