/*
 * Decompiled with CFR 0.152.
 */
package com.gus.chipmunk.selector;

import com.gus.chipmunk.ChipPart;
import com.gus.chipmunk.selector.ChipPartPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class ChipPartSelector
extends JPanel {
    private static final long serialVersionUID = 8860622658643122775L;
    private JPanel content;
    private JScrollPane jsp;
    private GridLayout layout;
    private Vector<ChipPart> cps = new Vector();
    private Vector<JPanel> jps = new Vector();

    public ChipPartSelector() {
        this(3);
    }

    public ChipPartSelector(int cols) {
        super(new GridLayout(1, 1));
        this.layout = new GridLayout(0, 3, 5, 5);
        this.content = new JPanel(this.layout);
        this.content.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jsp = new JScrollPane(this.content);
        this.jsp.setVerticalScrollBarPolicy(22);
        this.add(this.jsp);
    }

    public void setCols(int cols) {
        this.layout.setColumns(cols);
        this.doLayout();
    }

    public int getCols() {
        return this.layout.getColumns();
    }

    public void addPart(ChipPart cp) {
        JPanel p = new JPanel(new BorderLayout());
        ChipPartPanel cpp = new ChipPartPanel(cp);
        cpp.setDropEnabled(false);
        p.add((Component)cpp, "Center");
        this.content.add(p);
        this.jsp.setViewportView(this.content);
        this.repaint();
        this.cps.add(cp);
        this.jps.add(p);
    }

    public void delPart(ChipPart cp) {
        int i = this.cps.indexOf(cp);
        if (i == -1) {
            return;
        }
        this.cps.remove(i);
        this.content.remove(this.jps.remove(i));
        this.jsp.setViewportView(this.content);
        this.repaint();
    }

    public void delPart(String name) {
        int i = 0;
        Iterator<ChipPart> it = this.cps.iterator();
        while (it.hasNext()) {
            ChipPart cp = it.next();
            if (cp.name.equals(name)) {
                it.remove();
                this.content.remove(this.jps.remove(i));
                this.jsp.setViewportView(this.content);
                this.repaint();
                return;
            }
            ++i;
        }
    }
}

