/*
 * Decompiled with CFR 0.152.
 */
package com.gus.chipmunk.selector;

import com.gus.chipmunk.ChipMunkConstants;
import com.gus.chipmunk.TileSheet;
import com.gus.chipmunk.selector.TileSelectionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public abstract class ChipSelector
extends JPanel
implements ChipMunkConstants {
    private static final long serialVersionUID = -1662341064697513496L;
    private DefaultComboBoxModel list = new DefaultComboBoxModel();
    private TileSelectionPanel tsp = new TileSelectionPanel();
    private JComboBox cb = new JComboBox(this.list);

    protected abstract void selectionChanged();

    public ChipSelector() {
        super(new BorderLayout());
        this.add((Component)this.cb, "North");
        this.add((Component)this.tsp, "Center");
        this.cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ChipSelector.this.list.getSelectedItem() == null) {
                    ChipSelector.this.tsp.setImage(null);
                } else {
                    ChipSelector.this.tsp.setImage(((TileSheet)((ChipSelector)ChipSelector.this).list.getSelectedItem()).image);
                    ChipSelector.this.tsp.setSelectionWidth(0);
                }
                ChipSelector.this.selectionChanged();
            }
        });
        this.createSelector();
    }

    private void createSelector() {
        MouseAdapter ma = new MouseAdapter(){
            private Point origin = new Point(0, 0);

            @Override
            public void mousePressed(MouseEvent e) {
                Point tc = ChipSelector.this.tsp.tileCoordinates(e.getX(), e.getY());
                if (tc.x >= 18 || tc.y >= 16 || tc.x < 0 || tc.y < 0) {
                    return;
                }
                ChipSelector.this.tsp.setSelectionX(tc.x);
                ChipSelector.this.tsp.setSelectionY(tc.y);
                ChipSelector.this.tsp.setSelectionWidth(1);
                ChipSelector.this.tsp.setSelectionHeight(1);
                this.origin = tc;
                ChipSelector.this.selectionChanged();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int h;
                int y;
                int w;
                int x;
                Point tc = ChipSelector.this.tsp.tileCoordinates(e.getX(), e.getY());
                int nx = tc.x;
                int ny = tc.y;
                if (nx >= 18 || ny >= 16 || nx < 0 || ny < 0) {
                    return;
                }
                if (nx > this.origin.x) {
                    x = this.origin.x;
                    w = nx - this.origin.x + 1;
                } else if (nx < this.origin.x) {
                    x = nx;
                    w = this.origin.x - nx + 1;
                } else {
                    x = nx;
                    w = 1;
                }
                if (ny > this.origin.y) {
                    y = this.origin.y;
                    h = ny - this.origin.y + 1;
                } else if (ny < this.origin.y) {
                    y = ny;
                    h = this.origin.y - ny + 1;
                } else {
                    y = ny;
                    h = 1;
                }
                ChipSelector.this.tsp.setSelectionX(x);
                ChipSelector.this.tsp.setSelectionY(y);
                ChipSelector.this.tsp.setSelectionWidth(w);
                ChipSelector.this.tsp.setSelectionHeight(h);
                ChipSelector.this.selectionChanged();
            }
        };
        this.tsp.addMouseListener(ma);
        this.tsp.addMouseMotionListener(ma);
    }

    public void addTileSheet(TileSheet ts) {
        this.list.addElement(ts);
        this.list.setSelectedItem(ts);
    }

    public void delTileSheet(TileSheet ts) {
        this.list.removeElement(ts);
    }

    public BufferedImage getSelectedImage() {
        return this.tsp.getImage();
    }

    public Rectangle getSelection() {
        return new Rectangle(this.tsp.getSelectionX(), this.tsp.getSelectionY(), this.tsp.getSelectionWidth(), this.tsp.getSelectionHeight());
    }
}

