/*
 * Decompiled with CFR 0.152.
 */
package com.gus.chipmunk.selector;

import com.gus.chipmunk.ChipMunkConstants;
import com.gus.comps.image.ImagePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class TileSelectionPanel
extends ImagePanel
implements ChipMunkConstants {
    private static final long serialVersionUID = 8616127164447959680L;
    public static final Color DEFAULT_SELECTION_COLOR = Color.WHITE;
    private int selectionX;
    private int selectionY;
    private int selectionWidth;
    private int selectionHeight;
    private Color selectionColor;

    public TileSelectionPanel() {
    }

    public TileSelectionPanel(BufferedImage img) {
        super(img);
    }

    public Point tileCoordinates(int x, int y) {
        return new Point(x / 16, y / 16);
    }

    public Point tileCoordinates(Point p) {
        return this.tileCoordinates(p.x, p.y);
    }

    public int getSelectionX() {
        return this.selectionX;
    }

    public int getSelectionY() {
        return this.selectionY;
    }

    public int getSelectionWidth() {
        return this.selectionWidth;
    }

    public int getSelectionHeight() {
        return this.selectionHeight;
    }

    public void setSelectionX(int selectionX) {
        this.selectionX = selectionX;
        this.repaint();
    }

    public void setSelectionY(int selectionY) {
        this.selectionY = selectionY;
        this.repaint();
    }

    public void setSelectionWidth(int selectionWidth) {
        this.selectionWidth = selectionWidth;
        this.repaint();
    }

    public void setSelectionHeight(int selectionHeight) {
        this.selectionHeight = selectionHeight;
        this.repaint();
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        if (selectionColor == null) {
            selectionColor = DEFAULT_SELECTION_COLOR;
        }
        this.selectionColor = selectionColor;
        this.repaint();
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getSelectionWidth() != 0 && this.getSelectionHeight() != 0) {
            g.setColor(this.getSelectionColor());
            int x = 16 * this.getSelectionX();
            int y = 16 * this.getSelectionY();
            int w = 16 * this.getSelectionWidth();
            int h = 16 * this.getSelectionHeight();
            if (w == 0 || h == 0) {
                return;
            }
            if (w < 0) {
                w = -w;
                x -= w;
            }
            if (h < 0) {
                h = -h;
                y -= h;
            }
            g.draw3DRect(x, y, w - 1, h - 1, true);
            g.draw3DRect(x + 1, y + 1, w - 3, h - 3, false);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getImage() == null ? new Dimension(288, 256) : super.getPreferredSize();
    }
}

