/*
 * Decompiled with CFR 0.152.
 */
package com.gus.comps.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = 1534343121382722650L;
    private BufferedImage image;
    private boolean imageExpanded = false;

    public ImagePanel(BufferedImage img) {
        this.setImage(img);
    }

    public ImagePanel() {
        this((BufferedImage)null);
    }

    public boolean isImageExpanded() {
        return this.imageExpanded;
    }

    public void setImageExpanded(boolean imageExpanded) {
        this.imageExpanded = imageExpanded;
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public synchronized void setImage(BufferedImage image) {
        this.image = image;
        this.setPreferredSize(null);
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.image == null ? super.getPreferredSize() : new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            if (this.isImageExpanded()) {
                g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
            } else {
                g.drawImage(this.image, 0, 0, null);
            }
        }
    }
}

